unit Upl_main;
{$I '..\DSP.inc'}

interface

uses
  WinTypes, WinProcs, Messages,
  SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons,
  inifiles, Tabs, Grids, Outline,
{$IFDEF DSP_DATABASE}
  DB, DBTables,
{$ENDIF}
  ListNav,
  UPLClass,
  UPLClassExt;

type

  TFormDSPMain = class(TForm)
    Panel2: TPanel;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    NextBtn: TBitBtn;
    BackBtn: TBitBtn;
    Notebook: TNotebook;
    Label19: TLabel;
    Label18: TLabel;
    BtnReadUplFile: TSpeedButton;
    AboutBtn: TBitBtn;
    Label20: TLabel;
    Panel1: TPanel;
    TabSet1: TTabSet;
    NotebookAuthor: TNotebook;
    Label8: TLabel;
    Label7: TLabel;
    Label21: TLabel;
    AuthorURL: TEdit;
    AuthorEMail: TEdit;
    AuthorName: TEdit;
    Label35: TLabel;
    Label36: TLabel;
    AuthorGroupCB: TComboBox;
    AuthorInfo: TMemo;
    Label1: TLabel;
    Label6: TLabel;
    Label2: TLabel;
    FName: TEdit;
    ReplaceFile: TEdit;
    Label25: TLabel;
    Label17: TLabel;
    DescrFile: TComboBox;
    SupportImage: TImage;
    Label39: TLabel;
    Label40: TLabel;
    Support: TCheckBox;
    IniSaveBtn: TSpeedButton;
    Label44: TLabel;
    ClearBtn: TSpeedButton;
    CreateHTML: TSpeedButton;
    LaunchBrowser: TSpeedButton;
    GroupCB: TComboBox;
    GroupL: TLabel;
    ReplaceFileBtn: TSpeedButton;
    PanelC: TPanel;
    Panel4: TPanel;
    Label29: TLabel;
    Label5: TLabel;
    Label9: TLabel;
    AuthorGroupBtn: TSpeedButton;
    FileStatusCB: TComboBox;
    FileStatusL: TLabel;
    ListNavigator1: TListNavigator;
    AuthorUpdateDSP: TCheckBox;
    BtnUseCoAuthor: TSpeedButton;
    BtnUseDSPAuthors: TSpeedButton;
    Label10: TLabel;
    AuthorContact: TEdit;
    Label11: TLabel;
    CategoryL: TLabel;
    CategoryCB: TComboBox;
    CategoryBtn: TSpeedButton;
    PlatformL: TLabel;
    PlatformCB: TComboBox;
    Description: TMemo;
    Label4: TLabel;
    Label12: TLabel;
    AdditionalNote: TMemo;
    FileVersion: TEdit;
    Label3: TLabel;
    FullSource: TCheckBox;
    BtnReadDSP: TSpeedButton;
    BtnReadInfFile: TSpeedButton;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);

    procedure BtnReadUplFileClick(Sender: TObject);
    procedure IniSaveBtnClick(Sender: TObject);

      { navigation through pages }
    procedure NextBtnClick(Sender: TObject);
    procedure BackBtnClick(Sender: TObject);
    procedure NotebookPageChanged(Sender: TObject);

      { keypreview for Help }
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

    procedure SupportClick(Sender: TObject);
    procedure AuthorInfoChanged(Sender: TObject);
    procedure ShowHideOtherVersions(Sender: TObject);
    procedure CreateHTMLClick(Sender: TObject);
    procedure LaunchBrowserClick(Sender: TObject);
    procedure TabSet1Click(Sender: TObject);
    procedure LoadComboFromIniFile(Combo: TComboBox; ReadCategory: String);
    procedure GroupCBChange(Sender: TObject);
    procedure MemoChange(Sender: TObject);
    procedure AuthorGroupBtnClick(Sender: TObject);
    procedure CategoryBtnClick(Sender: TObject);
    procedure ReplaceFileBtnClick(Sender: TObject);
    procedure FNameExit(Sender: TObject);
    function GetUploadDestinationDir: String;
    procedure ListNavigator1Clicked(Sender: TObject;
      Button: TListNavigateBtn);
    procedure ListNavigator1Clicking(Sender: TObject;
      Button: TListNavigateBtn);
    procedure ListNavigator1CurrentChanged(Sender: TObject;
      Current: Integer);
    procedure BtnUseCoAuthorClick(Sender: TObject);
    procedure BtnUseDSPAuthorsClick(Sender: TObject);
    procedure BtnUseCoAuthorMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure BtnReadDSPClick(Sender: TObject);
    procedure BtnReadInfFileClick(Sender: TObject);
  private
    { Private declarations }
    EditingUploader: bool;
    procedure ReadUplFile(FileName: String);
    procedure ShowLoadedData;
    procedure BuildGroupList;
    procedure BuildAuthorGroupList;
    procedure BuildCompilerList;
    procedure BuildCompilerCategoriesList;
    procedure BuildPlatformList;

  public

     // object that holds all upload information I/O
     DSPInfo: TDSPInfoClassEx;

     // holds uploader information ( ie you )
     Uploader: TDSPAuthor;

     // list of authors that have been used as coauthors in your uploads
     Uploaders: TDSPAuthorList;

     IgnoreAuthorChanges: Boolean;
     procedure ScreenToAuthorObject;
     procedure AuthorObjectToScreen;
     procedure ScreenToDSPInfoObject;
     procedure DSPInfoObjectToScreen;
  end;


var
  FormDSPMain: TFormDSPMain;
  F: TextFile;

implementation

uses upl_cons,
     upl_util,
     upl_dlg0,    // About

{$IFDEF DSP_DATABASE}
     DataModule, // DM
     upl_dlg1,   // NoDSPDlg
     upl_dlg2,   // AuthorCategoryAdd
     upl_dlg3,   // CategoryOtherAddDlg
     upl_dlg4,   // CategoryAddDlg
     upl_dlg5,   // SelectDSPFileDlg
     upl_dlg7,   // SelectDSPAuthor
{$ENDIF}
     upl_dlg8,   // CoAuthor manager
     upl_dlg6;   // SelectCoAuthor     these two could be combined into one

{$R *.DFM}

(************************************************)
procedure TFormDSPMain.FormCreate(Sender: TObject);
var
  i: integer;
  S: String;
  SL: TStringList;
begin
  { create author object ie uploader, I mean you }
  Uploader:= TDSPAuthor.Create;
  { create coauthor list object }
  Uploaders:= TDSPAuthorList.Create;
  { Create DSP info object}
  DSPInfo:= TDSPInfoClassEx.Create;
  { add one author - you should type at least one, shouldn't you ? }
  DSPInfo.Authors.AddAuthor;
  { assign DSPInfo Author list with ListNavigator1 list }
  ListNavigator1.ListRef:= TList(DSPInfo.Authors.Items);
  { assign ListNavigator Events }

  { force to first page }
  NoteBook.PageIndex:= 0;
  { connect TabSets to appropriate Notebooks }
  TabSet1.Tabs:= NotebookAuthor.Pages;

{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase then
  Begin
    ReplaceFileBtn.Visible:= true;
    AuthorGroupBtn.Visible:= true;
    BtnUseDSPAuthors.Visible:= true;
    BtnReadDSP.Visible:= true;
  end;
{$ENDIF}

  // create compiler list
  BuildCompilerList;
  BuildGroupList;
  BuildAuthorGroupList;
  {
    read uploader(s) information from uploader.dat file
    kept in the same directory as executable
    this file helps you to keep the same uploader name
    between several uploads
  }
  S:= GetDirectory + cUPL_UploadersListInfoFile;
  if FileExists(S) then
  Begin
    Uploaders.ReadFromIniFile(S);
    BtnUseCoAuthor.Enabled:= true;
  End;

  if FileExists(GetDirectory + cUPL_UploaderInfoFile) then
    Uploader.ReadFromIniFile(GetDirectory + cUPL_UploaderInfoFile);

  if length(Uploader.AuthorName) > 0 then
  Begin
    EditingUploader:= false;
    DSPInfo.Authors.DSPAuthor[0].CopyFrom(Uploader);
    ListNavigator1CurrentChanged(ListNavigator1, 0);
  end else
  Begin
    ShowMessage('Please do save uploader information first.' + chr(13) +
                'This data will be kept in ' + chr(13) +
                 GetDirectory + cUPL_UploaderInfoFile + ' file.');
    NoteBook.PageIndex:= 1;
    { disable navigation buttons, they will be enabled
      when author infomation will be saved }
    NextBtn.Enabled:= false;
    BackBtn.Enabled:= false;
    { edit record }
    ListNavigator1.ObjectDataChanged;
    EditingUploader:= true;
  End;
  BuildPlatformList;
end;

procedure TFormDSPMain.BuildGroupList;
var
  i: integer;
Begin
  // build DSP FileGroupList, it will not be updated/changed during program execution

{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase
    then DSPInfo.Groups.BuildFromTable( DM.TblFilesGrp )
    else DSPInfo.Groups.BuildFromIniFile;
{$ELSE}
  DSPInfo.Groups.BuildFromIniFile;
{$ENDIF}

  // Fill GroupsCB combo box
  GroupCB.Clear;
  GroupCB.Items.BeginUpdate;
  if DSPInfo.Groups.Items.Count > 0 then
   for i:= 0 to DSPInfo.Groups.Items.Count - 1 do
    GroupCB.Items.Add(DSPInfo.Groups.Groups[i].GroupName);
  GroupCB.Items.EndUpdate;
End;

procedure TFormDSPMain.BuildAuthorGroupList;
Begin
  { load author categories }
  AuthorGroupCB.Clear;
  AuthorGroupCB.Items.BeginUpdate;
{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase then
  Begin
    DM.TblSitesCat.First;
    while not DM.TblSitesCat.EOF  do
    Begin
      AuthorGroupCB.Items.Add(DM.TblSitesCat.FieldByName('Description').AsString );
      DM.TblSitesCat.Next;
    End;
  end else LoadComboFromIniFile(AuthorGroupCB, cUPL_AuthorGroup);
{$ELSE}
  LoadComboFromIniFile(AuthorGroupCB, cUPL_AuthorGroup);
{$ENDIF}
  AuthorGroupCB.Items.EndUpdate;
End;

procedure TFormDSPMain.BuildCompilerList;
var
  i, k, LastTag: integer;
  aDSPCompilerEx: TDSPCompilerEx;
  ChBx: TUPLCheckBox;
  TE: TUPLEdit;
  Btn: TSpeedButton;
Begin
  { load compilers ComboBox; it will be displayed only when
    Component/Code group will be selected. }
  LastTag:= ReplaceFileBtn.Tag;
  // create compilers list first
{$IFDEF DSP_DATABASE}
  If DM.UseDSPDatabase
    then DSPInfo.Compilers.BuildFromTable(DM.TblDSPComp)
    else DSPInfo.Compilers.BuildFromIniFile;
{$ELSE}
  DSPInfo.Compilers.BuildFromIniFile;
{$ENDIF}

  // now use created list to create visible interface to it
  i:= PanelC.Height Div ( DSPInfo.Compilers.Items.Count + 1 );
  for k:= 0 to DSPInfo.Compilers.Items.Count - 1 do
  Begin
    aDSPCompilerEx:= TDSPCompilerEx(DSPInfo.Compilers.Compiler[k]);
    { create and setup checkbox }
    ChBx:= TUPLCheckBox.Create(Self);
    CHBx.Compiler:= aDSPCompilerEx;
    aDSPCompilerEx.Supported_CB:= ChBx;
    ChBx.Parent:= PanelC;
    ChBx.Caption:= aDSPCompilerEx.CompilerName;
    ChBx.Left:= Trunc( PanelC.Width * 0.02 );
    ChBx.Width:= Trunc( PanelC.Width * 0.28 );
    ChBx.Top:=  i * k + i Div 2;
    ChBx.Height:= i;
    ChBx.Visible:= true;

    { create and setup EditBox }
    TE:= TUPLEdit.Create(Self);
    TE.Compiler:= aDSPCompilerEx;
    aDSPCompilerEx.Available_edit:= TE;
    TE.Parent:= PanelC;
    TE.Left:= 2*ChBx.Left + ChBx.Width;
{$IFDEF DSP_DATABASE}
    If not DM.UseDSPDatabase
      then TE.Width:= PanelC.Width - TE.Left - ChBx.Left;
{$ELSE}
    TE.Width:= PanelC.Width - TE.Left - ChBx.Left;
{$ENDIF}
    TE.Top:= i * k  + i - TE.Height Div 2;
    TE.Visible:= true;
    Inc(LastTag);
    TE.Tag:= LastTag;
    TE.Clear;

{$IFDEF DSP_DATABASE}
    If DM.UseDSPDatabase then
    Begin
      { create and setup Button }
      Btn:= TSpeedButton.Create(Self);
      aDSPCompilerEx.FindInDB_SB:= Btn;
      Btn.Parent:= PanelC;
      Btn.Left:= PanelC.Width - ( 40 - Btn.Width ) div 2 - Btn.Width ;
      // recalculate TE.Width
      TE.Width:= PanelC.Width - TE.Left - 2 * ChBx.Left - Btn.Width;
      Btn.Top:=   i * k  + i - Btn.Height Div 2 + ( TE.Height - Btn.Height) div 2;
      Btn.Glyph.Assign(ReplaceFileBtn.Glyph);
      Btn.NumGlyphs:= 2;
      Btn.Visible:= true;
      Inc(LastTag);
      Btn.Tag:= LastTag;
      Btn.OnClick:= ReplaceFileBtnClick;
    End;
{$ENDIF}
  End;
End;

procedure TFormDSPMain.BuildPlatformList;
var
  i: integer;
Begin
  // load platform CB, it will be visible only for tools group
{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase
    then DSPInfo.Platforms.BuildFromTable( DM.TblFilesPlt )
    else DSPInfo.Platforms.BuildFromIniFile;
{$ELSE}
  DSPInfo.Platforms.BuildFromIniFile;
{$ENDIF}
  // Fill PlatformCB combo box
  PlatformCB.Clear;
  PlatformCB.Visible:= false;
  PlatformL.Visible:= false;
  PlatformCB.Items.BeginUpdate;
  if DSPInfo.Platforms.Items.Count > 0 then
   for i:= 0 to DSPInfo.Platforms.Items.Count - 1 do
    PlatformCB.Items.Add(DSPInfo.Platforms.Platforms[i].PlatformName);
  PlatformCB.Items.EndUpdate;
End;

procedure TFormDSPMain.BtnReadUplFileClick(Sender: TObject);
var
  S: string;
begin
  OpenDialog1.FileName:= '*.upl';
  OpenDialog1.Filter:= 'UplBuilder file (*.upl)|*.upl';
  If not OpenDialog1.Execute then Exit;
  DSPInfo.Reset;
  S:= ExtractFileName(OpenDialog1.Filename);
  SaveDialog1.FileName:= ExtractFilePath(OpenDialog1.Filename) +
       Copy(S, 1, Pos('.', S) - 1) + '.upl';
  DSPInfo.Reset;
  SaveDialog1.FileName:= OpenDialog1.Filename;
  DSPInfo.ReadFromIniFile(OpenDialog1.Filename);
  // now we have data loaded into DSPInfo object, put them onto the screen
  ShowLoadedData;
end;

procedure TFormDSPMain.ReadUplFile(FileName: String);
var
  S: string;
begin
  DSPInfo.Reset;
  S:= ExtractFileName(FileName);
  SaveDialog1.FileName:= ExtractFilePath(FileName) +
       Copy(S, 1, Pos('.', S) - 1) + '.upl';
  DSPInfo.Reset;
  SaveDialog1.FileName:= FileName;
  DSPInfo.ReadFromIniFile(FileName);
  // now we have data loaded into DSPInfo object, put them onto the screen
  ShowLoadedData;
end;


procedure TFormDSPMain.ShowLoadedData;
var
  i, k: integer;
begin
  EditingUploader:= false;
  // check that you are on the list
  if DSPInfo.Authors.FindAuthorByName(Uploader.AuthorName) = -1
    // oops I couldn't find you on this List - you HAVE TO be there
    then DSPInfo.Authors.DSPAuthor[DSPInfo.Authors.InsertAuthor(0)].CopyFrom(Uploader);

  // scan that all new authors are listed on Uploaders authors list
  if DSPInfo.Authors.Items.Count > 1 then
   for i:= 0 to DSPInfo.Authors.Items.Count - 1 do
   Begin
     k:= Uploaders.FindAuthorByName(DSPInfo.Authors.DSPAuthor[i].AuthorName);
     if ( k = -1 )
      // add this author to co-authors list ( Uploaders )
      then Uploaders.DSPAuthor[Uploaders.AddAuthor].CopyFrom(DSPInfo.Authors.DSPAuthor[i])
      // update author definition using Author description from Uploader list
      else DSPInfo.Authors.DSPAuthor[i].CopyFrom(Uploaders.DSPAuthor[k]);
   End;
   // Jump to the first page
   NoteBook.PageIndex:= 0;
  // OK, now we have to update screen, but first load category CB
  if CompareStr(DSPInfo.FileGroup, cUPL_ComponentCode) = 0
   then BuildCompilerCategoriesList;
  // copy DSPInfo object to the screen
  DSPInfoObjectToScreen;
  ListNavigator1.Current:= 0;
end;


procedure TFormDSPMain.IniSaveBtnClick(Sender: TObject);
var
  KeepUploaderName: String;
begin
  if ( Pos(cUPL_URLIndicator, FName.Text) = 0 )
    then SaveDialog1.FileName:= Copy(FName.Text, 1, Pos('.', FName.Text)) + 'upl'
    else SaveDialog1.FileName:= '*.upl';
  If not SaveDialog1.Execute then Exit;
  // !!
  DeleteFile(Savedialog1.Filename);
  ScreenToDSPInfoObject;
  // Save ALL authors to UploadFile, otherwise uploader ( exclude ) will not be added
  // there will not
  KeepUploaderName:= DSPInfo.Authors.ExcludeAuthor;
  DSPInfo.Authors.ExcludeAuthor:= '';
  DSPInfo.WriteToIniFile(SaveDialog1.FileName);
  DSPInfo.Authors.ExcludeAuthor:= KeepUploaderName;
end;

procedure TFormDSPMain.AboutBtnClick(Sender: TObject);
begin
  try
    FormAbout:= TFormAbout.Create(Self);
    FormAbout.ShowModal;
  finally
    FormAbout.Destroy;
  End;
end;

procedure TFormDSPMain.ClearBtnClick(Sender: TObject);
begin
  if messagedlg('Clear all fields ?', mtconfirmation,[mbYES,mbNo],0) = mrYES then
  Begin
    DSPInfo.Reset;
    // set some defaults that will be used later on
    DSPInfo.FileGroup:= cUPL_ComponentCode;
    DSPInfoObjectToScreen;
    // DSPInfo.Authors list is empty ! Add base author
    DSPInfo.Authors.AddAuthor;
    EditingUploader:= false;
    DSPInfo.Authors.DSPAuthor[0].CopyFrom(Uploader);
    // set current author in the navigator; there is a problem with synchronization
    // navigator and TList objects - I think that there should be some kind of
    // datalink between these two, but I can synchronize them this way
    ListNavigator1.Current:= 0;
    NoteBook.PageIndex:= 0;
  End;
end;

procedure TFormDSPMain.NotebookPageChanged(Sender: TObject);
begin
  BackBtn.Enabled:= Notebook.PageIndex <> 0;
  NextBtn.Enabled:= Notebook.PageIndex <> Notebook.Pages.Count - 1;
end;

procedure TFormDSPMain.NextBtnClick(Sender: TObject);
var
  Skip: integer;
  S: String;

   function ValidateC( C: TWinControl): bool;
   Begin
     result:= false;
     if C is TEdit
       then result:= Length(TEdit(C).Text) = 0;
     if C is TComboBox
       then result:= Length(TComboBox(C).Text) = 0;
     if C is TMemo
       then result:= Length(TMemo(C).Text) = 0;
     if result then
     Begin
       C.SetFocus;
       MessageBeep(0);
       ShowMessage('Why haven''t you entered all data I expect?');
       SysUtils.Abort;
     End;
   End;

   procedure CheckCompilers;
   var
     k: integer;
   Begin
     for k:= 0 to DSPInfo.Compilers.Items.Count - 1 do
       if DSPInfo.Compilers.Compiler[k].Supported then Exit; // one compiler is enough
     // oops, none has been selected, raise an error
     MessageBeep(0);
     ShowMessage('You have to select at least ONE compiler');
     SysUtils.Abort;
   End;

begin
  Skip:= 0;
  //check that everything was edited on page
  case Notebook.PageIndex of

    // from FileInfo1/3
    2: Begin
         ValidateC(FName);
         ValidateC(Description);
         ValidateC(GroupCB);
         ValidateC(FileStatusCB);
         // until there everything is fine, check that we will display Compilers page
         if CompareStr(GroupCB.Text, cUPL_ComponentCode) <> 0
           then Skip:= 1;
       end;

    // from Compilers Included/Available
    3: Begin
         // check that user has picked at least one check box
         // it will give me information what compiler categories should I display
         CheckCompilers;
         // store your latest selection
         S:= CategoryCB.text;
         BuildCompilerCategoriesList;
         // apply this selection again
         CategoryCB.ItemIndex:= CategoryCB.Items.IndexOf(S);
       End;

    // from FileInfo3/3
    4: Begin
         ValidateC(CategoryCB);
         if PlatformCB.Visible then ValidateC(PlatformCB);
         ValidateC(FileVersion);
       end;

  End; { case }

  if Notebook.PageIndex + 1 < Notebook.Pages.Count
    then Notebook.PageIndex:= Notebook.PageIndex + 1 + Skip;
end;

procedure TFormDSPMain.BackBtnClick(Sender: TObject);
var
  skip: integer;
begin
  skip:= 0;

  case Notebook.PageIndex of
    4: Begin
         // if we are not editing component/code skip this page
         if CompareStr(GroupCB.Text, cUPL_ComponentCode) <> 0
           then Skip:= 1;
       End;
  End;  { case }

  if Notebook.PageIndex > 0
   then Notebook.PageIndex:= Notebook.PageIndex - 1 - Skip;
end;

procedure TFormDSPMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_F1 then
  Begin
    { display page }
    Application.HelpCommand(HELP_CONTEXT, 1000 + 10 * Notebook.PageIndex);
    key:= 0;
  End;
end;

procedure TFormDSPMain.FormDestroy(Sender: TObject);
begin
  Uploader.Free;
  // prior FREE call, save uploaders list to the file
  if FileExists(GetDirectory + cUPL_UploadersListInfoFile) then
    DeleteFile(GetDirectory + cUPL_UploadersListInfoFile);
  Uploaders.WriteToIniFile(GetDirectory + cUPL_UploadersListInfoFile);
  Uploaders.Free;
  DSPInfo.Free;
end;

procedure TFormDSPMain.SupportClick(Sender: TObject);
begin
  SupportImage.Visible:= Support.Checked;
end;

procedure TFormDSPMain.AuthorInfoChanged(Sender: TObject);
begin
  if IgnoreAuthorChanges then Exit;
  if CompareStr(DSPInfo.Authors.DSPAuthor[ListNavigator1.Current].AuthorName,
                Uploader.AuthorName ) = 0 then  EditingUploader:= true;
  ListNavigator1.ObjectDataChanged;
end;

procedure TFormDSPMain.ShowHideOtherVersions(sender: TObject);
Begin
  with TEdit(FindComponent(Copy(TCheckBox(Sender).name, 1, 3) + 'a')) do Begin
    if TCheckBox(Sender).Checked then Text:= '';
    Visible:= not TCheckBox(Sender).Checked;
  End;
  TLabel(FindComponent(Copy(TCheckBox(Sender).name, 1, 3) + 'a_label')).Visible:=
            not TCheckBox(Sender).Checked;
End;

procedure TFormDSPMain.CreateHTMLClick(Sender: TObject);
var
  i: integer;
begin
  // first of all move everything to the DSPInfo
  ScreenToDSPInfoObject;
  AssignFile(F, GetDirectory + cUPL_html_test_file);
  rewrite(F);
  try
    writeln(F, '<HTML>');
    Writeln(F, '<HEAD>');
    Writeln(F, '<TITLE>DSP upload test page</TITLE>');
    Writeln(F, '</HEAD>');
    Writeln(F, '<BODY BGCOLOR="#c0c0c0">');
    Writeln(F);
    Writeln(F, '<TABLE WIDTH="98%" ALIGN=CENTER BORDER=1 BGCOLOR="#e8e8e8">');
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="100%">');
    Writeln(F, '<TABLE WIDTH="100%" BORDER=0>');
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="20%" ALIGN=CENTER>');
    // file name --------------------------------------------------------------------
    if Pos(cUPL_URLIndicator, DSPInfo.FileName) > 0 then
    Begin
      // file link is requested
      Write(F, '<IMG ALIGN=TOP SRC="gifs/link.gif" ALT="LINK">');
      Writeln(F, ' <A HREF="' + DSPInfo.FileName + '"><B>' +
                Get_URLFileNamePart(DSPInfo.FileName) + '</B></A>');
    End else
    Begin
      // file will be placed directly in DSP ftp area
      Write(F, '<A HREF="' + cUPL_SunSiteFTP + DSPInfo.FileDir + '/');
      Writeln(F, DSPInfo.FileName + '"><B>' + DSPInfo.FileName + '</B></A>');
    End;
    Writeln(F, '</TD>');
    // file size ------------------------------- don't worry, I'll find it myself
    Writeln(F, '<TD WIDTH="20%" ALIGN=CENTER>');
    Writeln(F, '<B>9.999.999</B>&nbsp;<FONT SIZE="-1"><i>bytes</i></FONT>');
    Writeln(F, '</TD>');
    // file status -------------------------------------------------------------
    Writeln(F, '<TD WIDTH="5%" ALIGN=RIGHT>');
    Write(F, '<IMG ALIGN=MIDDLE SRC="gifs/s_');
    if DSPInfo.Freeware
      then Writeln(F, 'free.gif" ALT="freeware">')
      else Writeln(F, 'share.gif" ALT="shareware">');
    Writeln(F, '</TD>');

    // source included ---------------------------------------------------------
    Writeln(F, '<TD WIDTH="5%" ALIGN=CENTER>');
    Write(F, '<IMG ALIGN=MIDDLE SRC="gifs/src_');
    if DSPInfo.WithSource
      then Write(F, 'inc.gif" ALT="with source">')
      else Write(F, 'no.gif" ALT="no source">');
    Writeln(F, '</TD>');

    // file compatibility ------------------------------------------------------
    //    suported xxx.gif, available xxxa.gif  not any xxxn.gif
    Writeln(F, '<TD WIDTH="50%" ALIGN=RIGHT>');
    if CompareStr(DSPInfo.FileGroup, cUPL_ComponentCode ) = 0 then
    Begin
      for i:= 0 to DSPInfo.Compilers.Items.Count - 1 do
      Begin
        if DSPInfo.Compilers.Compiler[i].Supported then
        Begin
          Write(F, '<IMG SRC="gifs/');
          Write(F, DSPInfo.Compilers.Compiler[i].CompilerID);
          Write(F, '.gif" ALT="' + DSPInfo.Compilers.Compiler[i].CompilerID );
          Write(F, ' compatible" ALIGN=MIDDLE>');
        End else
        if Length(DSPInfo.Compilers.Compiler[i].Available) > 0  then
        Begin
          Write(F, '<A HREF="' );
          if Pos(cUPL_URLIndicator, DSPInfo.Compilers.Compiler[i].Available) > 0 then
          Begin
            // file link is requested
            Write(F, DSPInfo.Compilers.Compiler[i].Available);
          End else
          Begin
            // file will be placed directly in DSP ftp area
            Write(F, cUPL_SunSiteFTP);
            if Pos('/', DSPInfo.Compilers.Compiler[i].Available ) > 0
              // user has defined destination directory
              then Write(F, DSPInfo.Compilers.Compiler[i].Available )
              else Begin
                Write(F, DSPInfo.Compilers.Compiler[i].CompilerID);
                if DSPInfo.Freeware
                  then Write(F, 'free')
                  else Write(F, 'share');
                Write(F, '/', DSPInfo.Compilers.Compiler[i].Available );
              End;
            Write(F, '">');
          End;
          Write(F, '<IMG SRC="gifs/');
          Write(F, DSPInfo.Compilers.Compiler[i].CompilerID + 'a');
          Write(F, '.gif" BORDER=0 ALIGN=MIDDLE ALT="Download ' +
                   DSPInfo.Compilers.Compiler[i].CompilerID +
                   ' compatible version"></A>');
        end else
        Begin
          Write(F, '<IMG SRC="gifs/');
          Write(F, DSPInfo.Compilers.Compiler[i].CompilerID + 'n');
          Write(F, '.gif" ALIGN=MIDDLE>');
        End;
      End
    End else Write(F, '&nbsp;');
    Writeln(F);
    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '</TABLE>'); // table end ( first row )
    Writeln(F, '</TD>');
    Writeln(F, '</TR>');    // first row end

    Writeln(F, '<TR>');     // second row begin
    Writeln(F, '<TD WIDTH="100%">');
    Writeln(F, '<TABLE WIDTH="100%" BORDER=0>');   // second row table begin
    Writeln(F, '<TR>');
    // file version  & update date ---------------------------------------------
    Writeln(F, '<TD WIDTH="15%" ALIGN=CENTER>');
    Writeln(F, '<TABLE WIDTH="100%" BORDER=0>');
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="35%" VALIGN=CENTER ALIGN=RIGHT>');
    Writeln(F, '<FONT SIZE="-1"><i>version:</i></FONT>');
    Writeln(F, '</TD>');
    Writeln(F, '<TD WIDTH="65%" VALIGN=CENTER ALIGN=LEFT>');
    Writeln(F, '&nbsp;<B>' + DSPInfo.FileVersion + '</B>');
    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="35%" VALIGN=CENTER ALIGN=RIGHT>');
    Writeln(F, '<FONT SIZE="-1"><i>last&nbsp;update:</i></FONT>');
    Writeln(F, '</TD>');
    Writeln(F, '<TD WIDTH="65%" VALIGN=CENTER ALIGN=LEFT>');
    Writeln(F, '&nbsp;<B>' + FormatDateTime('dd/mm/yyyy', SysUtils.Now) + '</B>');
    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="35%" VALIGN=CENTER ALIGN=RIGHT>');
    Writeln(F, '<FONT SIZE="-1"><i>on&nbsp;DSP&nbsp;from:</i></FONT>');
    Writeln(F, '</TD>');
    Writeln(F, '<TD WIDTH="65%" VALIGN=CENTER ALIGN=LEFT>');
    Writeln(F, '&nbsp;<B>' + FormatDateTime('dd/mm/yyyy', SysUtils.Now) + '</B>');
    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '</TABLE>');
    // download statistics ------------------------------ updated by DSP -------
    Writeln(F, '<TD WIDTH="30%" ALIGN=CENTER>');
    Writeln(F, '<FONT SIZE="-1">downloads</FONT>');
    if Pos(cUPL_URLIndicator, DSPInfo.FileName) = 0 then
    Begin
      // we can show statistics only for files directly downloadable from DSP
      // last week --------------
      Writeln(F, '<TABLE WIDTH="100%" BORDER=0>');
      Writeln(F, '<TR>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=RIGHT>');
      Writeln(F, '<FONT SIZE="-1"><i>last&nbsp;week:</i></FONT>');
      Writeln(F, '</TD>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=LEFT>');
      Writeln(F, '&nbsp;<B>999</B>');
      Writeln(F, '</TD>');
      Writeln(F, '</TR>');
      // last update --------------
      Writeln(F, '<TR>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=RIGHT>');
      Writeln(F, '<FONT SIZE="-1"><i>last&nbsp;update:</i></FONT>');
      Writeln(F, '</TD>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=LEFT>');
      Writeln(F, '&nbsp;<B>9.999</B>');
      Writeln(F, '</TD>');
      Writeln(F, '</TR>');
      // total downloads ---------
      Writeln(F, '<TR>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=RIGHT>');
      Writeln(F, '<FONT SIZE="-1"><i>total:</i></FONT>');
      Writeln(F, '</TD>');
      Writeln(F, '<TD WIDTH="50%" ALIGN=LEFT>');
      Writeln(F, '&nbsp;<B>9.999</B>');
      Writeln(F, '</TD>');
      Writeln(F, '</TR>');
      Writeln(F, '</TABLE>');
    end else  Writeln(F, '<BR><B>n/a</B>');
    Writeln(F, '</TD>');

    // uploader(s) info --------------------------------------------------------
    Writeln(F, '<TD WIDTH="55%">');
    Writeln(F, '<TABLE WIDTH="100%" BORDER=0>');

    for i:= 0 to DSPInfo.Authors.Items.Count - 1 do
    Begin
      Writeln(F, '<TR>');
      Writeln(F, '<TD WIDTH="10%" ALIGN=RIGHT>');
      //-- home page
      if Length(DSPInfo.Authors.DSPAuthor[i].AuthorHome) > 0
        then Write(F, '<A HREF="' + DSPInfo.Authors.DSPAuthor[i].AuthorHome  +
                      '"><IMG SRC="gifs/home2.gif" BORDER=0 ALIGN=MIDDLE></A>');
      // it isn't mistake, there will be a direct link to your author page on DSP
      Writeln(F, '<IMG SRC="gifs/ainfo.gif" BORDER=0 ALIGN=MIDDLE>');
      Writeln(F, '</TD>');
      Writeln(F, '<TD WIDTH="90%" ALIGN=LEFT>');
      Write(F, '<b>');
      if Length(DSPInfo.Authors.DSPAuthor[i].Contact) > 0
        then Write(F, DSPInfo.Authors.DSPAuthor[i].Contact + ' ( ' +
                      DSPInfo.Authors.DSPAuthor[i].AuthorName + ' )')
        else Write(F, DSPInfo.Authors.DSPAuthor[i].AuthorName);
      Writeln(F, '</b>');
      Writeln(F, '</TD>');
      Writeln(F, '</TR>');
    End;
    Writeln(F, '</TABLE>');

    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '</TABLE>');   // table end ( second row )

    Writeln(F, '</TD>');
    Writeln(F, '</TR>');      // second row end

    Writeln(F, '<TR>');       // third row begin
    Writeln(F, '<TD WIDTH="100%" ALIGN=LEFT>');

    Writeln(F, '<TABLE WIDTH="100%" CELLPADDING=5 BORDER=0>');   // third row table begin
    Writeln(F, '<TR>');
    Writeln(F, '<TD WIDTH="100%" ALIGN=LEFT>');
    Writeln(F, DSPInfo.UploadDesc.Text);
    if Length(DSPInfo.Note) > 0 then
    Begin
      Write(F, '<BR>');
      Writeln(F, DSPInfo.Note);
    End;
    // external description file
    if ( Length(DSPInfo.ExtDescFile) > 1 ) and
       ( Pos(cUPL_URLIndicator, DSPInfo.FileName ) = 0 ) then
    Begin
      // external description files are allowed only for files stored in DSP
      // FTP area - they have to follow DSP naming convention where links do not have to
      Write(F, '<CENTER><FONT SIZE="-1">detailed file description</FONT>&nbsp;');
      Write(F, '<A HREF="' + cUPL_SunSiteFTP + DSPInfo.FileDir + '/');
      Write(F, Copy(DSPInfo.FileName, 1, Pos('.', DSPinfo.FileName)));
      if DSPInfo.ExtDescFile[1] in ['T', 't']
        then Write(F, 'txt')
        else Write(F, 'htm');
      Writeln(F, '"><IMG ALIGN=MIDDLE border=0 SRC="gifs/doc.gif"></A>');
    End;

    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '</TABLE>');   // table end

    Writeln(F, '</TD>');
    Writeln(F, '</TR>');
    Writeln(F, '</TABLE>');      // DSP FILE info output end
    Writeln(F, '<P>');
    Writeln(F, '<H2>Author info</H2>');
    Writeln(F, '<P>');

    for i:= 0 to DSPInfo.Authors.Items.Count - 1 do
    Begin
      Writeln(F, '<P>');
      Writeln(F, '<TABLE WIDTH="98%" COLLSPAN=5 ALIGN=CENTER BORDER=1 BGCOLOR="#e8e8e8">');
      Writeln(F, '<TR>');
      Writeln(F, '<TD WIDTH="20%" ALIGN=RIGHT>');
      Writeln(F, '<b>Author/Company</b>&nbsp;&nbsp;&nbsp;');
      Writeln(F, '</TD>');
      Writeln(F, '<TD WIDTH="80%" ALIGN=LEFT>');
      Writeln(F, '&nbsp;&nbsp;&nbsp;' + DSPInfo.Authors.DSPAuthor[i].AuthorName);
      Writeln(F, '</TD>');
      Writeln(F, '</TR>');     // first line

      if Length(DSPInfo.Authors.DSPAuthor[i].Contact) > 0 then
      Begin
        Writeln(F, '<TR>');
        Writeln(F, '<TD WIDTH="20%" ALIGN=RIGHT>');
        Writeln(F, '<b>Contact</b>&nbsp;&nbsp;&nbsp;');
        Writeln(F, '</TD>');
        Writeln(F, '<TD WIDTH="80%" ALIGN=LEFT>');
        Writeln(F, '&nbsp;&nbsp;&nbsp;' + DSPInfo.Authors.DSPAuthor[i].Contact);
        Writeln(F, '</TD>');
        Writeln(F, '</TR>');     // second line
      End;

      if Length(DSPInfo.Authors.DSPAuthor[i].AuthorEmail) > 0 then
      Begin
        Writeln(F, '<TR>');
        Writeln(F, '<TD WIDTH="20%" ALIGN=RIGHT>');
        Writeln(F, '<b>E-mail</b>&nbsp;&nbsp;&nbsp;');
        Writeln(F, '</TD>');
        Writeln(F, '<TD WIDTH="80%" ALIGN=LEFT>');
        Writeln(F, '&nbsp;&nbsp;&nbsp;<a href="mailto:' +
                   DSPInfo.Authors.DSPAuthor[i].AuthorEmail + '">' +
                   DSPInfo.Authors.DSPAuthor[i].AuthorEmail + '</A>');
        Writeln(F, '</TD>');
        Writeln(F, '</TR>');     // third line
      End;

      if Length(DSPInfo.Authors.DSPAuthor[i].AuthorHome) > 0 then
      Begin
        Writeln(F, '<TR>');
        Writeln(F, '<TD WIDTH="20%" ALIGN=RIGHT>');
        Writeln(F, '<b>Home Site/Page</b>&nbsp;&nbsp;&nbsp;');
        Writeln(F, '</TD>');
        Writeln(F, '<TD WIDTH="80%" ALIGN=LEFT>');
        Writeln(F, '&nbsp;&nbsp;&nbsp;<a href="' +
                   DSPInfo.Authors.DSPAuthor[i].AuthorHome + '">' +
                   '<IMG ALIGN=MIDDLE BORDER=0 SRC="gifs/home.gif">' +
                   DSPInfo.Authors.DSPAuthor[i].AuthorHome + '</A>');
        Writeln(F, '</TD>');
        Writeln(F, '</TR>');     // fourth line
      End;

      if CompareStr(DSPInfo.Authors.DSPAuthor[i].AuthorGroup, cUPL_IgnoreSite) <> 0 then
      Begin
        Writeln(F, '<TR>');
        Writeln(F, '<TD WIDTH="20%" ALIGN=RIGHT>');
        Writeln(F, '<b>Site Category</b>&nbsp;&nbsp;&nbsp;');
        Writeln(F, '</TD>');
        Writeln(F, '<TD WIDTH="80%" ALIGN=LEFT>');
        Writeln(F, '&nbsp;&nbsp;&nbsp;' + DSPInfo.Authors.DSPAuthor[i].AuthorGroup);
        Writeln(F, '</TD>');
        Writeln(F, '</TR>');     // fifth line
      End;

      if Length(DSPInfo.Authors.DSPAuthor[i].AuthorInfo.Text) > 0 then
      Begin
        Writeln(F, '<TR>');
        Writeln(F, '<TD COLSPAN=2>');
         Writeln(F, '<TABLE WIDTH="100%" ALIGN=LEFT BORDER=0>');
         Writeln(F, '<TR>');
         Writeln(F, '<TD WIDTH="100%">');
         Writeln(F, DSPInfo.Authors.DSPAuthor[i].AuthorInfo.Text );
         Writeln(F, '</TD>');
         Writeln(F, '</TR>');
         Writeln(F, '</TABLE>');
        Writeln(F, '</TD>');
        Writeln(F, '</TR>');     // sixth line
      End;
      Writeln(F, '</TABLE>');
    End;

    Writeln(F, '</BODY>');
    Writeln(F, '</HTML>');

  finally
    CloseFile(F);
  End;

end;





procedure TFormDSPMain.LaunchBrowserClick(Sender: TObject);
begin
 // whenever you call this procedure, it creates a new instance
 // of www browser - to avoid this just use RELOAD button on www browser
  Execute_html_file(GetDirectory + cUPL_html_test_file);
end;

procedure TFormDSPMain.TabSet1Click(Sender: TObject);
begin
  NotebookAuthor.PageIndex:= TabSet1.TabIndex;
end;

procedure TFormDSPMain.LoadComboFromIniFile(Combo: TComboBox; ReadCategory: String);
var
  ini: TIniFile;
  i, count: integer;
begin
  ini:= TIniFile.Create(GetDirectory + cUPL_UplBuilderDataFile);
  try
    count:= Ini.ReadInteger(ReadCategory, cUPL_count, 0);
    if count = 0 then Abort;
    for i:= 1 to count do
      Combo.Items.Add(Ini.ReadString(ReadCategory, IntToStr(i), ''));
  finally
    Ini.Free;
  End;
end;

{*******************************************}

procedure TFormDSPMain.GroupCBChange(Sender: TObject);

{$IFDEF DSP_DATABASE}
  procedure FromDB;
  Begin
    DM.TblFilesGrp.IndexName:= 'ByFileGrpName';
    if  not DM.TblFilesGrp.FindKey( [ GroupCB.text ] )
      then raise Exception.Create('Invalid Group Name');
    if DM.TblFilesGrp.FieldByName('FileGrpID').AsInteger = 1  then
    Begin
      { for compiler/Code we don't need platform to be displayed }
      PlatformCB.Visible:= false;
      PlatformL.Visible:= false;
    End else
    Begin
      CategoryCB.Clear;
      DM.TblFilesCat.IndexName:= 'ByFileCatName';
      CategoryCB.Items.BeginUpdate;
      DM.TblFilesCat.First;
      while not DM.TblFilesCat.EOF do
      Begin
        if ( DM.TblFilesCat.FieldByName('FileGrpID').AsInteger =
             DM.TblFilesGrp.FieldByName('FileGrpID').AsInteger ) then
        CategoryCB.Items.Add(DM.TblFilesCat.FieldByName('FileCatName').AsString );
        DM.TblFilesCat.Next;
      End;
      CategoryCB.Items.EndUpdate;
      { for tools category show platform }
      if CompareStr(cUPL_DSPTools, GroupCB.Text) = 0 then
      Begin
        PlatformCB.Visible:= true;
        PlatformL.Visible:= true;
      end else
      Begin
        PlatformCB.Visible:= false;
        PlatformL.Visible:= false;
      End;
    End;
  End;
{$ENDIF}

  procedure FromIni;
  Begin
    if CompareStr(GroupCB.text, cUPL_ComponentCode ) = 0 then
    Begin
      // for compiler/Code we don't need platform to be displayed
      PlatformCB.Visible:= false;
      PlatformL.Visible:= false;
    end else
    Begin
      // clear all compiler settings
      CategoryCB.Clear;
      CategoryCB.Items.BeginUpdate;
      LoadComboFromIniFile(CategoryCB, GroupCB.text);
      CategoryCB.Items.EndUpdate;
      // for tools category show platform
      if CompareStr(cUPL_DSPTools, GroupCB.Text) = 0 then
      Begin
        PlatformCB.Visible:= true;
        PlatformL.Visible:= true;
      end else
      Begin
        PlatformCB.Visible:= false;
        PlatformL.Visible:= false;
      End;
    End;
  End;

Begin
{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase
    then FromDB
    else FromIni;
{$ELSE}
  FromIni;
{$ENDIF}
end;

procedure TFormDSPMain.MemoChange(Sender: TObject);
var
  i: integer;
  Len: Integer;
begin
  Len:= 0;
  if TMemo(Sender).Lines.Count = 1 then Len:= Length(TMemo(Sender).Text) else
  Begin
    for i:= 0 to TMemo(Sender).Lines.Count - 1 do
      Len:= Len + Length(TMemo(Sender).Lines[i]);
    Len:= Len + TMemo(Sender).Lines.Count - 1;
  End;
  if Len > 250 then
  Begin
    TMemo(Sender).Color:= clRed ;
    TMemo(Sender).Hint:= IntToStr(Len) + ' charactes - too long !!!' ;
  end else
  Begin
    TMemo(Sender).Color := clWindow;
    TMemo(Sender).Hint:= IntToStr(Len);
  End;
end;

procedure TFormDSPMain.AuthorGroupBtnClick(Sender: TObject);
var
  s: String;
begin
{$IFDEF DSP_DATABASE}
  // add author group to DSP database
  try
    AuthorCategoryAdd:= TAuthorCategoryAdd.Create(Self);
    // find record
    if length(AuthorGroupCB.Text) > 0
      then DM.TblSitesCat.FindKey( [ AuthorGroupCB.Text ] );
    if AuthorCategoryAdd.ShowModal = mrOK then
    Begin
      // store selection
      s:= DM.TblSitesCat.FieldByName('Description').AsString;
      // as we dont' know that sth was REALLY changed or no, just reload entire CB
      AuthorGroupCB.Clear;
      AuthorGroupCB.Items.BeginUpdate;
      DM.TblSitesCat.First;
      while not DM.TblSitesCat.EOF  do
      Begin
        AuthorGroupCB.Items.Add(DM.TblSitesCat.FieldByName('Description').AsString);
        DM.TblSitesCat.Next;
      End;
      AuthorGroupCB.Items.EndUpdate;
      AuthorGroupCB.Text:= S;
      AuthorInfoChanged(AuthorCategoryAdd );
    End;
  finally
    AuthorCategoryAdd.Destroy;
  End;
{$ENDIF}
end;

procedure TFormDSPMain.CategoryBtnClick(Sender: TObject);
var
  S: String;
Begin
{$IFDEF DSP_DATABASE}
  S := CategoryCB.Text;
  if CompareStr(GroupCB.Text, cUPL_ComponentCode) = 0 then
  Begin
    // add compiler catogory to DSP
    CategoryAddDlg:= TCategoryAddDlg.Create(Self);
    try
      // set position in the grid
      DM.TblFilesCat.IndexName:= 'ByFileCatName';
      if Length( S ) > 0 then DM.TblFilesCat.FindKey( [ CategoryCB.Text ] );
      if CategoryAddDlg.ShowModal = mrOK
        // store current selection
        then S := DM.TblFilesCat.FieldByName('FileCatName').AsString;
    finally
      CategoryAddDlg.Destroy;
    End;
    BuildCompilerCategoriesList;
  end else
  Begin
    // add non compiler catogory to DSP
    DM.TblFilesGrp.IndexName:= 'ByFileGrpName';
    if not DM.TblFilesGrp.FindKey( [ GroupCB.text ] ) then Exit;
    CategoryOtherAddDlg:= TCategoryOtherAddDlg.Create(Self);
    try
      // set position in grid
      DM.TblFilesCat.IndexName:= 'ByFileCatName';
      if Length( S ) > 0 then DM.TblFilesCat.FindKey( [ CategoryCB.Text ] );
      if CategoryOtherAddDlg.ShowModal = mrOK then
        // store selected category
        S := DM.TblFilesCat.FieldByName('FileCatName').AsString;
    finally
      CategoryOtherAddDlg.Destroy;
    End;
    GroupCBChange(GroupCB);
  End;
  if Length(S) > 0 then
    if CategoryCB.Items.IndexOf(S) = -1
      then raise Exception.Create('Selected category : ' + S + #13 + 'not on the Category List')
      else CategoryCB.Text:= S;
{$ENDIF}
End;


procedure TFormDSPMain.ReplaceFileBtnClick(Sender: TObject);
var
  EB: TEdit;
  S: String;

  function GetEditFromTag(Tag: integer): TEdit;
  var
    i: integer;
  Begin
    for i:= 0 to ComponentCount - 1 do
     if ( Components[i].Tag = Tag )then
    Begin
      result:= TEdit(Components[i]);
      exit;
    End;
    result:= nil;
  End;

begin
{$IFDEF DSP_DATABASE}
  if SelectDSPFileDlg = nil
    then Application.CreateForm(TSelectDSPFileDlg, SelectDSPFileDlg);
  try
    if SelectDSPFileDlg.ShowModal = mrOK then
    Begin
      EB:= GetEditFromTag(TSpeedButton(Sender).Tag - 1);
      if EB = nil then Exit;
      if Pos(cUPL_URLIndicator, DM.QueryFile.FieldByName('FileName').AsString) = 0
         then S:= DM.QueryFile.FieldByName('DSPDir').AsString + '/'
         else S:= '';
      EB.Text:= S + DM.QueryFile.FieldByName('FileName').AsString;
    End;
  finally
    SelectDSPFileDlg.Close;
  End
{$ENDIF}
end;

procedure TFormDSPMain.FNameExit(Sender: TObject);
var
  i: integer;
  s: string;
const
  diff: integer = Ord('a') - Ord('A');
begin
  if Length(FName.Text) = 0 then Exit;
  if Pos(cUPL_URLIndicator, FName.Text) > 0 then Exit;
  { URL can contain upper case }
  s:= FName.Text;
  for i:= Length(s) downto 1 do
   if ( s[i] in [ 'A' .. 'Z' ] ) then
    s[i]:= Char(Ord(s[i]) + diff );
  FName.Text:= s;
end;

function TFormDSPMain.GetUploadDestinationDir: String;
var
  Ini: TIniFile;
Begin
{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase then
  Begin
    DM.TblFilesGrp.IndexName:= 'ByFileGrpName';
    if DM.TblFilesGrp.FindKey( [ GroupCB.text ] )
      then result:= DM.TblFilesGrp.FieldByName('DSPDir').AsString
      else raise Exception.Create('Could not locate: ' + GroupCB.text + #13 +
                 'in FileGrp.DB table');
  End else
  Begin
    ini:= TIniFile.Create(GetDirectory + cUPL_UplBuilderDataFile);
    try
      result:= Ini.ReadString(GroupCB.Text, cUPL_DSPDir, '');
    finally
      Ini.Free;
    End;
  End;
{$ELSE}
  ini:= TIniFile.Create(GetDirectory + cUPL_UplBuilderDataFile);
  try
    result:= Ini.ReadString(GroupCB.Text, cUPL_DSPDir, '');
  finally
    Ini.Free;
  End;
{$ENDIF}
End;

procedure TFormDSPMain.ListNavigator1Clicked(Sender: TObject;
                                    Button: TListNavigateBtn);
var
  ThisAuthor: TDSPAuthor;
  i: integer;
begin
  case button of
     LNQB_APPLY:
        Begin
           // manage uploader record
           if EditingUploader then
           Begin
             // update author object from screen fields
             ScreenToAuthorObject;
             ThisAuthor:= DSPInfo.Authors.DSPAuthor[ListNavigator1.Current];
             Uploader.CopyFrom(ThisAuthor);
             Uploader.WriteToIniFile(GetDirectory + cUPL_UploaderInfoFile);
             DSPInfo.Authors.ExcludeAuthor:= Uploader.AuthorName;
             EditingUploader:= false;
             BackBtn.Enabled:= true;
             NextBtn.Enabled:= true;
           End else
           Begin
             // if this was someone else add this author to your co-authors list
             // update author object from screen fields
             ThisAuthor:= DSPInfo.Authors.DSPAuthor[ListNavigator1.Current];
             // ThisAuthor still contains old data - prior to update
             // make sure that the same author will not be placed twice
             i:= Uploaders.FindAuthorByName(ThisAuthor.AuthorName);

             // update author definition in upload author list
             ScreenToAuthorObject;
             if i >= 0
             // the author has been found - we are updating an existing author
               // overwrite this author
               then Uploaders.DSPAuthor[i].CopyFrom(ThisAuthor)
               // create new author in co-author list object
               else Uploaders.DSPAuthor[Uploaders.AddAuthor].CopyFrom(ThisAuthor);
             // file will be stored on FormDestroy event
           End;
        End;

     LNQB_CANCEL:
        Begin

        End;

     LNQB_DELETE:
        Begin
           // author deleted from current upload should be available for adding
           BtnUseCoAuthor.Enabled:= true;
        End;
   End; { case }
end;

procedure TFormDSPMain.ListNavigator1Clicking(Sender: TObject;
                                   Button: TListNavigateBtn);
var
  i: integer;
begin
  case button of
     LNQB_APPLY:
        Begin
          // author info should contain at least its name
          if  length(AuthorName.Text) = 0 then
            raise Exception.Create('Each author should have a name !');
          // make sure that we are not attepting to double author
          // ie author1 name is NO1
          //    author2 name is No2
          // we are editing author1 and trying to change its name to No2
          i:= DSPInfo.Authors.FindAuthorByName(AuthorName.Text);
          if ( i >= 0 ) and ( i <> ListNavigator1.Current ) then
            raise Exception.Create('Author: ' + AuthorName.Text + ' already defined in your list');
        End;
     LNQB_ADD:
        Begin
          if DSPInfo.Authors.Items.Count = 0
            then DSPInfo.Authors.Items.Add(DSPInfo.Authors.CreateAuthor )
            else DSPInfo.Authors.Items.Insert(ListNavigator1.Current+1, DSPInfo.Authors.CreateAuthor )
        End;

     LNQB_CANCEL:
        Begin
           // you cannot cancel when editing your author data for the first time
           if EditingUploader and ( ListNavigator1.NavStatus = LNS_INSERT ) then
              raise Exception.Create('Sorry - you have to save author data first!');
        End;

     LNQB_DELETE:
        Begin
           // you cannot delete your data
           if ( DSPInfo.Authors.Items.Count = 1 ) or
              ( ( DSPInfo.Authors.Items.Count > 1 ) and
              ( CompareStr(DSPInfo.Authors.DSPAuthor[ListNavigator1.Current].AuthorName,
                Uploader.AuthorName ) = 0 ))
            then
              raise Exception.Create('Sorry - you cannot delete yourself from the authors list');
        End;
  End; { case }
end;

procedure TFormDSPMain.ListNavigator1CurrentChanged(Sender: TObject; Current: Integer);
Begin
  IgnoreAuthorChanges:= true;
  AuthorObjectToScreen;
  IgnoreAuthorChanges:= false;
End;

procedure TFormDSPMain.AuthorObjectToScreen;
var
  ThisAuthor: TDSPAuthor;
begin
  // show data from the current record on the screen
  if ListNavigator1.Current >= 0 then
  Begin
    ThisAuthor:= DSPInfo.Authors.DSPAuthor[ListNavigator1.Current];
    AuthorName.Text:= ThisAuthor.AuthorName;
    AuthorContact.Text:= ThisAuthor.Contact;
    AuthorEMail.Text:= ThisAuthor.AuthorEMail;
    AuthorURL.Text:= ThisAuthor.AuthorHome;
    AuthorGroupCB.Text:= ThisAuthor.AuthorGroup;
    AuthorInfo.Lines.Assign(ThisAuthor.AuthorInfo);
    AuthorUpdateDSP.Checked:= ThisAuthor.UpdateDSP;
  End;
end;

procedure TFormDSPMain.ScreenToAuthorObject;
var
  ThisAuthor: TDSPAuthor;
begin
  ThisAuthor:= DSPInfo.Authors.DSPAuthor[ListNavigator1.Current];
  ThisAuthor.AuthorName:= AuthorName.Text;
  ThisAuthor.Contact:= AuthorContact.Text;
  ThisAuthor.AuthorEMail:= AuthorEMail.Text;
  ThisAuthor.AuthorHome:= AuthorURL.Text;
  ThisAuthor.AuthorGroup:= AuthorGroupCB.Text;
  ThisAuthor.AuthorInfo.Assign(AuthorInfo.Lines);
  ThisAuthor.UpdateDSP:= AuthorUpdateDSP.Checked;
End;

procedure TFormDSPMain.ScreenToDSPInfoObject;
Begin
  // all, except authors and compilers
  DSPInfo.FileName:= FName.Text;
  DSPInfo.ReplaceFile:= ReplaceFile.Text;
  DSPInfo.FileVersion:= FileVersion.Text;
  DSPInfo.UploadDesc.Assign(Description.Lines);
  DSPInfo.ExtDescFile:= DescrFile.Text;
  DSPInfo.WithSource:= FullSource.Checked;
  DSPInfo.FileGroup:= GroupCB.Text;
  if CompareStr(GroupCB.Text, cUPL_ComponentCode) = 0
    then DSPInfo.FilePlatform:= ''
    else DSPInfo.FilePlatform:= PlatformCB.Text;
  DSPInfo.Freeware:= CompareStr(FileStatusCB.Text, cUPL_Freeware) = 0;
  DSPInfo.Note:= AdditionalNote.Text;
  DSPInfo.Category:= CategoryCB.Text;
  DSPInfo.Support:= Support.Checked;
End;

procedure TFormDSPMain.DSPInfoObjectToScreen;
Begin
  // all, except authors and compilers
  FName.Text := DSPInfo.FileName;
  ReplaceFile.Text := DSPInfo.ReplaceFile;
  FileVersion.Text := DSPInfo.FileVersion;
  Description.Lines.Assign(DSPInfo.UploadDesc);
  DescrFile.ItemIndex:= DescrFile.Items.IndexOf(DSPInfo.ExtDescFile);
  FullSource.Checked:= DSPInfo.WithSource;
  GroupCB.ItemIndex:= GroupCB.Items.IndexOf(DSPInfo.FileGroup);
  GroupCBChange(GroupCB);
  if CompareStr(GroupCB.Text, cUPL_ComponentCode) <> 0
    then PlatformCB.ItemIndex:= PlatformCB.Items.IndexOf(DSPInfo.FilePlatform);
  if DSPInfo.Freeware
    then FileStatusCB.ItemIndex:= FileStatusCB.Items.IndexOf(cUPL_Freeware)
    else FileStatusCB.ItemIndex:= FileStatusCB.Items.IndexOf(cUPL_Shareware);
  AdditionalNote.Text:= DSPInfo.Note;
  CategoryCB.ItemIndex:= CategoryCB.Items.IndexOf(DSPInfo.Category);
  Support.Checked:= DSPInfo.Support;
  SupportImage.Visible:= DSPInfo.Support;
End;

procedure TFormDSPMain.BtnUseCoAuthorClick(Sender: TObject);
var
  i, k: integer;
begin
  SelectCoAuthor:= TSelectCoAuthor.Create(Self);
  try
    // build co-author list, list only these that are not included in currently edited upload description
    SelectCoAuthor.AuthorList.Items.BeginUpdate;
    for i:= 0 to Uploaders.Items.Count - 1 do
     if DSPInfo.Authors.FindAuthorByName(Uploaders.DSPAuthor[i].AuthorName) = -1  then
      SelectCoAuthor.AuthorList.Items.Add(Uploaders.DSPAuthor[i].AuthorName);
    SelectCoAuthor.AuthorList.Items.EndUpdate;
    if SelectCoAuthor.ShowModal = mrOK then
    Begin
      // scan for selected items
      for i:= 0 to SelectCoAuthor.AuthorList.Items.Count - 1 do
       if SelectCoAuthor.AuthorList.Selected[i] then
       Begin
         // locate Author in Uploaders list
         k:= Uploaders.FindAuthorByName(SelectCoAuthor.AuthorList.Items.Strings[i]);
         DSPInfo.Authors.DSPAuthor[DSPInfo.Authors.AddAuthor].CopyFrom(
                       Uploaders.DSPAuthor[k]);
         // switch to the new record
         ListNavigator1.Current:= ListNavigator1.Current + 1;
       End;
    End;
  finally
    SelectCoAuthor.Destroy;
  End;
end;

procedure TFormDSPMain.BtnUseDSPAuthorsClick(Sender: TObject);
var
  S: String;
begin
{$IFDEF DSP_DATABASE}
  SelectDSPAuthor:= TSelectDSPAuthor.Create(Self);
  try
    // assign Author Table to the grid
    SelectDSPAuthor.DBGrid1.DataSource:= DM.DSAuthors;
    if SelectDSPAuthor.ShowModal = mrOK then
    Begin
      // pick selected record
      S:= DM.TblAuthors.FieldByname('AuthorName').AsString;
      if DSPInfo.Authors.FindAuthorByName( S ) = -1 then
      Begin
        DSPInfo.Authors.DSPAuthor[DSPInfo.Authors.AddAuthor].ReadFromTable(DM.TblAuthors, DM.TblSitesCat);
        ListNavigator1.Current:= ListNavigator1.Current + 1;
      end
       else raise Exception.Create('Author ' + S + ' already on your authors list');
      if Uploaders.FindAuthorByName( S ) = -1 then
        Uploaders.DSPAuthor[Uploaders.AddAuthor].CopyFrom(
               DSPInfo.Authors.DSPAuthor[ListNavigator1.Current]);
    End;
  finally
    SelectDSPAuthor.Destroy;
  End;
{$ENDIF}
End;

procedure TFormDSPMain.BuildCompilerCategoriesList;
var
  S: String;
  CompilerIDx: Integer;
Begin
  // deduce base compiler and load categories for this compiler
  CompilerIdx:= TDSPCompilerListEx(DSPInfo.Compilers).GetBaseCompilerIdx;
  S:= DSPInfo.Compilers.Compiler[CompilerIdx].CompilerID;
  CategoryCB.Clear;
  CategoryCB.Items.BeginUpdate;
{$IFDEF DSP_DATABASE}
  if DM.UseDSPDatabase then
  Begin
    DM.TblFilesCat.IndexName:= 'ByFileCatName';
    DM.TblFilesCat.First;
    while not DM.TblFilesCat.EOF do
    Begin
      if ( DM.TblFilesCat.FieldByName('FileGrpID').AsInteger =  1 ) and
         ( DM.TblFilesCat.FieldByName(S).AsBoolean ) then
        CategoryCB.Items.Add(DM.TblFilesCat.FieldByName('FileCatName').AsString );
      DM.TblFilesCat.Next;
    End;
  end else
  Begin
    // load this section into combo
    S:= DSPInfo.Compilers.Compiler[CompilerIdx].CompilerName;
    LoadComboFromIniFile(CategoryCB, S);
  End;
{$ELSE}
  // load this section into combo
  S:= DSPInfo.Compilers.Compiler[CompilerIdx].CompilerName;
  LoadComboFromIniFile(CategoryCB, S);
{$ENDIF}
  CategoryCB.Items.EndUpdate;
End;


procedure TFormDSPMain.BtnUseCoAuthorMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then
  Begin
    CoAuthorManager:= TCoAuthorManager.Create(Self);
    try
      CoAuthorManager.Uploader:= Uploader;
      CoAuthorManager.AuthorsUPL:= DSPInfo.Authors;
      CoAuthorManager.AuthorsCO:=  Uploaders;
      CoAuthorManager.SetUpLists;
      CoAuthorManager.ShowModal;
    finally
      CoAuthorManager.Close;
    End;
  End;
end;

procedure TFormDSPMain.BtnReadInfFileClick(Sender: TObject);
  // import from *.inf file ( old format )
var
  i: integer;
  S: String;
begin
  OpenDialog1.FileName:= '*.inf';
  OpenDialog1.Filter:= 'Inf Builder file (*.inf)|*.inf';
  If not OpenDialog1.Execute then Exit;
  DSPInfo.Reset;
  S:= ExtractFileName(OpenDialog1.Filename);
  SaveDialog1.FileName:= ExtractFilePath(OpenDialog1.Filename) +
       Copy(S, 1, Pos('.', S) - 1) + '.upl';
  DSPInfo.ReadFromInfFile(OpenDialog1.FileName);
  ShowLoadedData;
End;

procedure TFormDSPMain.BtnReadDSPClick(Sender: TObject);
var
 dlg_result: word;
 FileID: Integer;
 i: integer;
 S: String;
begin
  // import from DSP database, of course only for database mode
{$IFDEF DSP_DATABASE}
  // first lunch File Dialog
  if SelectDSPFileDlg = nil
    then Application.CreateForm(TSelectDSPFileDlg, SelectDSPFileDlg);
  try
    dlg_result:= SelectDSPFileDlg.ShowModal;
  finally
    SelectDSPFileDlg.Close;
  end;

  // Quit if not pressed OK button
  if dlg_result <> mrOK then Exit;
  DSPInfo.Reset;
  // check that we have valid field to do the search : FileID
  if ( DM.QueryFile.FindField('FileID') = nil )  then
    raise Exception.Create('FileID filed of Files.DB not in query');
  DM.TblFiles.IndexName:= '';
  if not DM.TblFiles.FindKey( [ DM.QueryFile.FindField('FileID').AsInteger ]) then
    raise Exception.Create('Couldn''t locate FileID filed: ' +
                            DM.QueryFile.FindField('FileID').AsString +
                           ' + in Files.DB table');
  // Files -> FilesAut -> Authors
  // first import authors
  DM.TblFilesAut.IndexName:= 'ByFileID';
  DM.TblAuthors.IndexName:= '';
  if DM.TblFilesAut.FindKey( [ DM.TblFiles.FieldByName('FileID').AsInteger ] ) then
  while DM.TblFiles.FieldByName('FileID').AsInteger =
        DM.TblFilesAut.FieldByName('FileID').AsInteger do
  Begin
    // find author
    if not DM.TblAuthors.FindKey( [ DM.TblFilesAut.FieldByName('AuthorID').AsInteger ] )
      then if MessageDlg('Cannot locate Author ID : ' +
                         DM.TblFilesAut.FieldByName('AuthorID').AsString +  #13#10 +
                         'Continue ?', mtConfirmation, [mbYes, mbNo], 0) = mrNo
             then SysUtils.Abort;

    // add all authors from Authors.DB table
    DSPInfo.Authors.DSPAuthor[DSPInfo.Authors.AddAuthor].ReadFromTable(
             DM.TblAuthors, DM.TblSitesCat);
    DM.TblFilesAut.Next;
  End;
  // restore previous
  DM.TblAuthors.IndexName:= 'ByAuthorName';

  // import base file, I assume that you do not change upload name
  DSPInfo.FileID:= DM.TblFiles.FieldByName('FileID').AsInteger;
  DSPInfo.FileName:= DM.TblFiles.FieldByName('FileName').AsString;
  DSPInfo.FileDir:= DM.TblFiles.FieldByName('DSPDir').AsString;
  DSPInfo.Freeware:= DM.TblFiles.FieldByName('Free').AsBoolean;
  // locate group this file belongs to
  DM.TblFilesGrp.IndexName:= '';
  if not DM.TblFilesGrp.FindKey( [ DM.TblFiles.FieldByName('FileGrpID').Asinteger ] ) then
    raise Exception.Create('Couldn''t locate group ID: ' + DM.TblFiles.FieldByName('FileGrpID').AsString );
  DSPInfo.FileGroup:= DM.TblFilesGrp.FieldByName('FileGrpName').AsString;
  // locate category this file belongs to
  DM.TblFilesCat.IndexName:= '';
  if not DM.TblFilesCat.FindKey( [ DM.TblFiles.FieldByName('FileCatID').Asinteger ] ) then
    raise Exception.Create('Couldn''t locate category ID: ' + DM.TblFiles.FieldByName('FileCatID').AsString );
  DSPInfo.Category:= DM.TblFilesCat.FieldByName('FileCatName').AsString;
  DSPInfo.ReplaceFile:= DSPInfo.FileDir + '/' + DSPInfo.FileName;
  DSPInfo.UploadDesc.Text:= DM.TblFiles.FieldByName('Description').AsString;
  DSPInfo.Note:= DM.TblFiles.FieldByName('Condition').AsString;
  DSPInfo.FileVersion:= DM.TblFiles.FieldByName('FileVersion').AsString;

  if ( not DM.TblFiles.FieldByName('ExtDescFile').IsNull ) and
     ( Length(DM.TblFiles.FieldByName('ExtDescFile').AsString ) > 0 ) then
  // ignore first element
  for i:= 1 to DescrFile.Items.Count - 1 do
   if DescrFile.Items.Strings[i][1] = DM.TblFiles.FieldByName('ExtDescFile').AsString[1]
     then DSPInfo.ExtDescFile:= DescrFile.Items.Strings[i];

  DSPInfo.WithSource:= DM.TblFiles.FieldByName('WithSource').AsBoolean;
  DSPInfo.UpdateDSP:= true;

  // deduce UPL file name
  if Pos(cUPL_URLIndicator, DSPInfo.FileName ) > 0 then
  Begin
    // URL was entered
    i:= Length(DSPInfo.FileName);
    while ( DSPInfo.FileName[i] <> '/' ) and ( I > 0 ) do Dec(i);
    S:= Copy( DSPInfo.FileName, i, Length(DSPInfo.FileName) - i + 1 );
    DSPInfo.UPLFile:= Copy( S, 1, Pos('.', S ) - 1) + '.upl';
  End
   else DSPInfo.UPLFile:= Copy( DSPInfo.FileName, 1, Pos('.', DSPInfo.FileName ) - 1 ) + '.upl';

  // locate platform  ( if any )
  if not DM.TblFiles.FieldByName('PlatformID').IsNull then
  Begin
    DM.TblFilesPlt.IndexName:= '';
    if not DM.TblFilesPlt.FindKey( [ DM.TblFiles.FieldByName('PlatformID').Asinteger ] ) then
      raise Exception.Create('Couldn''t locate platform ID: ' + DM.TblFiles.FieldByName('PlatformID').AsString );
    DSPInfo.FileGroup:= DM.TblFilesPlt.FieldByName('PlatformName').AsString;
  End;
  // scan for available compilers and compatible products
  if CompareStr(DSPInfo.FileGroup, cUPL_ComponentCode) = 0 then
  Begin
    DSPInfo.Compilers.ReadFromTable(DM.TblFiles);
    // if we have available - it is FileID
    for i:= 0 to DSPInfo.Compilers.Items.Count - 1 do
     if Length(DSPInfo.Compilers.Compiler[i].Available) > 0 then
      if DM.TblFiles.FindKey( [ DSPInfo.Compilers.Compiler[i].Available ]) then
      Begin
        if Pos( cUPL_URLIndicator, DM.TblFiles.FieldByName('FileName').AsString  ) > 0
          then DSPInfo.Compilers.Compiler[i].Available:=
                  DM.TblFiles.FieldByName('FileName').AsString
          else DSPInfo.Compilers.Compiler[i].Available:=
                  DM.TblFiles.FieldByName('DSPDir').AsString + '/' +
                  DM.TblFiles.FieldByName('FileName').AsString;
      End else DSPInfo.Compilers.Compiler[i].Available :=
                  DSPInfo.Compilers.Compiler[i].Available + '????????????????????????';
  End;
  // OK, now we have data in DSPInfo object - put them onto the screen
  ShowLoadedData;
{$ENDIF}
end;


end.


